#include <bits/stdc++.h>
using namespace std;

struct Node {
	int name;
	int id;
	vector<Node*> children;
	Node* parentNode = nullptr;

	Node(int oid, int oname, Node* oroot)
		: name(oname), id(oid), parentNode(oroot) {}
};

Node* findNodeById(int id, Node* currentNode) {
	if (currentNode->id == id) {
		return currentNode;
	}
	for (auto* node : currentNode->children) {
		Node* a = findNodeById(id, node);
		if (a != nullptr) {
			return a;
		}
	}
	return nullptr;
}

Node* findNodeByName(int name, Node* currentNode) {
	if (currentNode->name == name) {
		return currentNode;
	}
	for (auto* node : currentNode->children) {
		Node* a = findNodeByName(name, node);
		if (a != nullptr) {
			return a;
		}
	}
	return nullptr;
}



void print(const Node* currentNode) {
	cout << "+" << endl;
	cout << currentNode->name << endl;
	for (const auto* node : currentNode->children) {
		print(node);
	}
	cout << "-" << endl;
}

unordered_map<int, int> findDistanceFromNodeToName(Node* location, Node* from, int l, int r) {
	if (location->name == name) {
		return 0;
	}
	for (auto* a : location->children) {
		if (a != from) {
			int b = findDistanceFromNodeToName(a, location, name);
			if (b != -1) {
				return b + 1;
			}
		}
	}
	if (location->parentNode != from) {
		int b = findDistanceFromNodeToName(location->parentNode, location, name);
		if (b != -1) {
			return b + 1;
		}
	}
	return -1;
}


int main(int argc, char const *argv[])
{
	int n;
	cin >> n;
	vector<int> vec(n + 1);
	for (int i = 1; i <= n; i++) {
		cin >> vec[i];
	}

	Node* root;
	root = new Node(1, vec[1], nullptr);

	unordered_map<int, Node*> mapi;
	mapi[root->name] = root;


	for (int i = 0; i < n - 1; i++) {
		int a, b;
		cin >> a >> b;
		Node* nodea = findNodeById(a, root);

		Node* newnode = new Node(b, vec[b], nodea);
		nodea->children.push_back(newnode);
		mapi[vec[b]] = newnode;
	}
	int q = 0, t, ia, ib, l, r, x;
	cin >> q;
	for (int i = 0; i < q; i++) {
		cin >> t;
		if (t == 1) {
			cin >> ia >> ib;

			//SPED THIS UP
			int a = mapi[ia]->name;
			mapi[ia]->name = mapi[ib]->name;
			mapi[ib]->name = a;

			Node* nodea = mapi[ia];
			mapi[ia] = mapi[ib];
			mapi[ib] = nodea;
		}
		else if (t == 2) {
			cin >> l >> r >> x;
			int maxi = 0;
			Node* startingNode = mapi[x];
			for (int i = l; i <= r; i++)
				maxi = max(maxi, findDistanceFromNodeToName(startingNode, nullptr, i));
			cout << maxi << endl;
		}

	}
	//print(root);


	return 0;
}